/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth;

import com.ibm.hwmca.ui.bonsai.config.ResourcesNodeConfigBean;
import com.ibm.hwmca.ui.bonsai.config.WorkareaConfigBean;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.ResourceTreeNode;
import java.beans.PropertyChangeListener;
import java.util.Set;

public abstract class ResourceMutableTreeNode
extends ResourceTreeNode {
    private AbstractTreeNodeListener listener;

    protected ResourceMutableTreeNode(ResourceMutableTreeNode clonee, BonsaiTreeNode parent) {
        this(clonee, parent, clonee.getXMLKey());
    }

    protected ResourceMutableTreeNode(ResourceMutableTreeNode clonee, BonsaiTreeNode parent, String idPostfix) {
        super(clonee, parent, idPostfix);
    }

    protected ResourceMutableTreeNode(ResourcesNodeConfigBean configBean, BonsaiTreeNode parent, WorkareaConfigBean defaultWorkarea, Set filters) {
        this(configBean, parent, defaultWorkarea, filters, configBean.getKey());
    }

    protected ResourceMutableTreeNode(ResourcesNodeConfigBean configBean, BonsaiTreeNode parent, WorkareaConfigBean defaultWorkarea, Set filters, String idPostfix) {
        super(configBean, parent, defaultWorkarea, filters, idPostfix);
    }

    public void prepareForActivation() {
        super.prepareForActivation();
        if (this.listener != null) {
            this.listener.register();
        }
    }

    public void prepareForRemoval() {
        super.prepareForRemoval();
        if (this.listener != null) {
            this.listener.deregister();
        }
    }

    public void prepareForReplacement(BonsaiTreeNode node) {
        super.prepareForReplacement(node);
        if (this.listener != null) {
            ResourceMutableTreeNode mutableNode = (ResourceMutableTreeNode)node;
            mutableNode.listener = this.listener;
            this.listener.setOwner(mutableNode);
            this.listener = null;
        }
    }

    protected void setListener(AbstractTreeNodeListener listener) {
        this.listener = listener;
    }

    protected abstract class AbstractTreeNodeListener
    implements PropertyChangeListener {
        private ResourceMutableTreeNode owner;

        protected AbstractTreeNodeListener(ResourceMutableTreeNode owner) {
            this.owner = owner;
        }

        private void setOwner(ResourceMutableTreeNode owner) {
            this.owner = owner;
        }

        protected ResourceMutableTreeNode getOwner() {
            return this.owner;
        }

        protected abstract void register();

        protected abstract void deregister();
    }
}

